 ; Ŀ
 ;   Coord - draws lines until it hears a <Return>, then inserts a N or E  
 ;   coordinate string based on the angle of the first line segment.       
 ;   Reco - update coordinate text to reflect the position of the          
 ;   polyline whose handle is contained in its extended entity data.       
 ;   Copyright 1994, 1997, 2010 by Rocket Software Ltd.                    
 ;   Armadillo popsicles, the fad food of 2023 - get your tongue ready.    
 ; 

 ; Ŀ
 ;   Subroutine Cordin - insert coordinate text and attach the handle of   
 ;   the polyline to the text as xdata.                                    
 ;   Takes five arguments: the angle, insertion point, string, scale, and  
 ;   the associated polyline ename.                                        
 ; 
 (DEFUN CORDIN (angrad pa str scal phandl /)
 ; Ŀ
 ;   Change to the correct layer, make it if it doesn't exist.             
 ; 
  (if (tblsearch "layer" "text2")
      (setvar "clayer" "text2")
      (command "layer" "m" "text2" "c" "1" "" ""))
 ; Ŀ
 ;   Find the correct text position and angle, draw it.                    
 ; 
  (cond ((or (>= angrad (* pi 1.75)) (< angrad (* pi 0.25)))  ; right
         (setq pa (polar pa 0 (* scal 2)))
         (command "text" "ml" pa (* 2.5 scal) "0" str))
        ((and (> angrad (* pi 0.25)) (<= angrad (* pi 0.75))) ; top
         (setq pa (polar pa (/ pi 2) (* scal 2)))
         (command "text" "ml" pa (* 2.5 scal) "90" str))
        ((and (> angrad (* pi 0.75)) (<= angrad (* pi 1.25))) ; left
         (setq pa (polar pa pi (* scal 2)))
         (command "text" "mr" pa (* 2.5 scal) "0" str))
        ((and (>= angrad (* pi 1.25)) (< angrad (* pi 1.75))) ; down
         (setq pa (polar pa (* pi 1.5) (* scal 2)))
         (command "text" "mr" pa (* 2.5 scal) "90" str)))
 ; Ŀ
 ;   Attach the polyline handle as extended entity data.                   
 ; 
  (if (not (tblsearch "appid" "coord"))
      (regapp "coord"))
  (setq enam (entlast))
  (setq thou (list -3 (append (list "coord") (list (cons 1005 phandl)))))
  (setq entt (append (entget enam) (list thou)))
  (entmod entt)
 (princ))
 ; Ŀ
 ;   Cordin end.                                                           
 ; 

 ; Ŀ
 ;   Subroutine Ptaer - convert the X and Y coordinates of a point to      
 ;   N and E offsets from 0,0, return as a list.                           
 ; 
 (DEFUN PTAER (pa / xx yy len)
;  (setq pa (trans pa 0 1))
 ; Ŀ
 ;   The next two lines have the (read (rtos)) because Autolisp insisted   
 ;   on fixing 165143.0 in the LL&E drawing 92107718 to 165142.  This      
 ;   addition sets the value in amber before fixing it.                    
 ;   But why the bug?                                                      
 ;   Fix truncates rather than rounds off a real.  The position of the     
 ;   block in question was 165142.999999999, which was displayed rounded   
 ;   up but Fixed down.  One could apply a rounding correction, but this   
 ;   way, as in life, what you see is what you expect.                     
 ; 
;  (setq xx (itoa (fix (read (rtos (car pa) 2 2)))))
;  (setq yy (itoa (fix (read (rtos (cadr pa) 2 2)))))
 ; Ŀ
 ;   Some time later - that didn't work with 2002 (although everyone else  
 ;   is using 2006 by now) so I added the following adjustment:            
 ; 
  (setq xx (itoa (fix (+ 0.5 (read (rtos (car pa) 2 2))))))
  (setq yy (itoa (fix (+ 0.5 (read (rtos (cadr pa) 2 2))))))
; (print xx)
; (print yy)
 ; Ŀ
 ;   (setq xx (itoa (fix (car pa))))       The original code.              
 ;   (setq yy (itoa (fix (cadr pa))))                                      
 ; 
  (while (< (strlen xx) 5)
         (setq xx (strcat "0" xx)))
  (while (< (strlen yy) 5)
         (setq yy (strcat "0" yy)))
  (if (< (strlen xx) 6)
         (setq xx (strcat "0" xx)))
  (if (< (strlen yy) 6)
         (setq yy (strcat "0" yy)))
  (setq len (strlen xx))
  (setq xx (strcat "E " (substr xx 1 (- len 5)) "+"
                       (substr xx (- len 4) 2) "."
                       (substr xx (- len 2))))
  (setq len (strlen yy))
  (setq yy (strcat "N " (substr yy 1 (- len 5)) "+"
                       (substr yy (- len 4) 2) "."
                       (substr yy (- len 2))))
 (list xx yy))
 ; Ŀ
 ;   Ptaer end.                                                            
 ; 

 ; Ŀ
 ;   Coord.                                                                
 ; 
 (DEFUN C:COORD ( / clay disc aa bb stangl ang str ptlst)
  (setvar "cmdecho" 0)
  (command "undo" "be")
 ; Ŀ
 ;   Load Misps.lsp, which contains the ps/ms scaling subroutines.         
 ; 
  (if (or (null wasp) (null misps))
      (if (null (load "misps" ()))
          (prompt "\n** The File Misps.lsp Is Not Available. **\n")))
  (setq disc (misps))
  (setq clay (getvar "clayer"))
  (setq aa (getpoint "Start point:\n"))
  (setq ptlst (ptaer aa))
  (command "pline" aa)
  (while (setq bb (getpoint aa "Next point:\n"))
         (if (= (distance aa bb) 0) (write-line "Try moving the cursor\n")
             (progn
                  (if (null stangl) (setq stangl (angle aa bb)))
                  (command bb)
                  (setq ang (angle aa bb))
                  (if bb (setq aa bb)))))
  (command "")
  (setq plenam (entlast))
  (if (= (getvar "handles") 0) (command "handles" "on"))
  (setq phandl (cdr (assoc 5 (entget plenam))))
  (setq aa (polar aa ang (* disc 2)))
  (if (or (or (>= stangl (* pi 1.75)) (< stangl (* pi 0.25)))    ; right
          (and (> stangl (* pi 0.75)) (<= stangl (* pi 1.25))))  ; left
      (setq str (cadr ptlst))
      (setq str (car ptlst)))
  (cordin ang aa str disc phandl)
  (setvar "clayer" clay)
 (princ))


 ; Ŀ
 ;   Subroutine Reco: update the text in a coordinate string to show the   
 ;   position of the associated polyline.                                  
 ;   Takes one argument, the text ename.                                   
 ;   Returns the ename of the polyline or nil if there wasn't one.         
 ; 
 (DEFUN RECO (enam / entt plhand plentt ten elv ptlst stangl str)
  (setq entt (entget enam (list "coord")))
  (setq plhand (cdr (cadadr (assoc -3 entt))))
 ; Ŀ
 ;   Notes:                                                                
 ;    1. If the entity whose handle is contained in the 1005 group is      
 ;       deleted then Audit will set the group to (1005 . "0").            
 ;       (Handent "0") returns nil, as does any invalid handle.            
 ;    2. Copying an entity duplicates xdata, which will in this case       
 ;       result in two entities referencing one line.                      
 ; 
  (if (and (setq plentt (handent plhand))
           (entget plentt))
      (progn
           (setq ten (cdr (assoc 10 (entget (entnext plentt)))))
           (setq elv (cdr (assoc 10 (entget (entnext (entnext plentt))))))
           (setq ptlst (ptaer ten))
           (setq stangl (angle ten elv))
           (if (or (or (>= stangl (* pi 1.75)) (< stangl (* pi 0.25)))  ; right
                   (and (> stangl (* pi 0.75)) (<= stangl (* pi 1.25)))) ; left
               (setq str (cadr ptlst))
               (setq str (car ptlst)))
           (entmod (subst (cons 1 str) (assoc 1 entt) entt)))
      (progn
           (setq plentt ())
           (prompt "\nInvalid coordinate text - Can't find a marker line.")
           (cr (cdr (assoc 10 entt)))
           (setq str "Not Valid")
           (entmod (subst (cons 1 str) (assoc 1 entt) entt))
           (entmod (append (entget enam) (list (list -3 (list "coord")))))))
 plentt)
 ; Ŀ
 ;   Reco end.                                                             
 ; 

 ; Ŀ
 ;   Cr - mark a point passed as the only argument.                        
 ; 
 (DEFUN CR (pa / reps pa rad rad2 angg colo)
  (setq reps 45)
  (setq colo 2)
  (setq rad (/ (getvar "viewsize") 10))
  (setq rad2 (/ rad 2))
  (setq angg 0)
  (setq incr (/ pi (/ reps 2)))
  (repeat reps
          (grdraw (polar pa angg rad2) (polar pa angg rad) colo)
          (setq angg (+ angg incr)))
 (princ))
 ; Ŀ
 ;   Cr end.                                                               
 ; 

 ; Ŀ
 ;   Reco.                                                                 
 ; 
 (DEFUN C:RECO ( / ss num enam plenam sub pa pb namlst )
  (setvar "cmdecho" 0)
  (command "undo" "mark")
  (prompt "Select entities to update or <Return> for all: ")
  (if (or (setq ss (ssget (list (list -3 (list "coord")))))
          (setq ss (ssget "X" (list (list -3 (list "coord"))))))
      (progn
           (setq num 0)
           (while (setq enam (ssname ss num))
                  (grtext -2 (itoa (setq num (1+ num))))
                  (setq plenam (reco enam))
                  (if (setq sub (assoc plenam namlst))
                      (progn
                           (prompt
                        "\nDuplicate text referencing single indicator line.")
                           (cr (setq pa (cdr (assoc 10 (entget enam)))))
                           (cr (setq pb (cdr (assoc 10 (entget (cadr sub))))))
                           (grdraw pa pb 2))
                      (setq namlst (append namlst (list
                                                     (list plenam enam))))))))
 (princ))

(prompt "C:COORD C:RECO")
(princ)
